-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.victory = false
    self.defeat = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.timer = 4
      AddGoals(self)
    end
  end
  
  if self.defeat then
		self.p0:FailQuest('D5G_GOAL_1')
    self.p0:FailQuest('D5G_GOAL_2')
		
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      Citadels.ForceDefeat()
    end
  end
  
  if self.victory then
		self.p0:WinQuest('D5G_GOAL_1')
    self.p0:WinQuest('D5G_GOAL_2')
		
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      Citadels.SetAchievementDone(10)
      Citadels.ForceVictory()
    end
  end  
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = true
  elseif target == "defeat" then
    self.defeat = true
  end
end

function AddGoals(self)
  g1PosX = Game:GetEntity("mainBase"):GetPosition().x
  g1PosY = Game:GetEntity("mainBase"):GetPosition().y
  q1PosX = Game:GetEntity("ironMine"):GetPosition().x
  q1PosY = Game:GetEntity("ironMine"):GetPosition().y
  q2PosX = Game:GetEntity("stoneMine"):GetPosition().x
  q2PosY = Game:GetEntity("stoneMine"):GetPosition().y
  
  self.p0:AddQuest('D5G_GOAL_1','main')
  self.p0:SetQuestPosition('D5G_GOAL_1', g1PosX, g1PosY)
  
  self.p0:AddQuest('D5G_GOAL_2','main')
  
  self.p0:AddQuest('D05_STONE','side')
  self.p0:SetQuestPosition('D05_STONE', q2PosX, q2PosY)
  
  self.p0:AddQuest('D05_IRON','side')  
  self.p0:SetQuestPosition('D05_IRON', q1PosX, q1PosY)
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    --OnAfterSceneLoaded(self)
    self.loaded = true
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
  end
end
